#ifndef __MNG_FUNCTIONS_H__
#define __MNG_FUNCTIONS_H__

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "CRYS_RSA_Types.h"
/*
   *  Object %name    : MNG_Functions.h
   *  State           :  %state%
   *  Creation date   :  Aug 4 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief Generic Secure Boot h file (API and structures )
   *
   *  \version 
   *  \author Danb
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/*
*   @brief  The CC executes the following:
*               1) verifying that the SHA256 of { E||N } is correlate with the value stored in the OTP according to the key type.
*               2) Executes the CRYS RSA build operation and returns the UserPubKey object
*   
*   @param[in] keyType - the key type : 1 - OEM , 0 - SJTAG.
*   @param[in] keyIndex - in case of the OEM key, the index of the key
*   @param[in] E[in]- The public exponent.
*   @param[in] N_len[in] - the modulus length.
*   @param[in] N_ptr[in] - the modulus vector.
*   @param[out] UserPubKey_ptr[out] - the RSA public key object.
*
*   Returns:  Status of the operation.
*/
DxError_t DX_MNG_RSA_BuildPlatformPubKey(DxUint32_t             keyType,
                                         DxUint32_t             keyIndex, 
                                         CRYS_RSAUserPubKey_t*  UserPubKey_ptr,
                                         DxUint8_t*             E_ptr,					
                                         DxUint32_t             E_len,
                                 		     DxUint32_t             N_len,
                                         DxUint8_t*             N_ptr);



#endif



